/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.debuffs.DataDrivenDebuffType;
import dev.toma.gunsrpg.common.debuffs.DebuffType;
import dev.toma.gunsrpg.common.debuffs.IDebuffBuilder;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.debuffs.IStagedDebuff;
import java.util.Objects;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DummyDebuffType<D extends IStagedDebuff>
extends DebuffType<D> {
    private final Supplier<DataDrivenDebuffType<?>> linkedDebuff;

    private DummyDebuffType(DummyBuilder<D> builder) {
        super(builder);
        this.linkedDebuff = ((DummyBuilder)builder).linkedDebuff;
    }

    @Override
    public D onTrigger(IDebuffContext context, Random random, @Nullable Object data) {
        DataDrivenDebuffType type;
        DataDrivenDebuffType<?> linked;
        IPlayerData playerData = context.getData();
        IDebuffs debuffs = playerData.getDebuffControl();
        if (debuffs.hasDebuff(linked = this.linkedDebuff.get())) {
            return null;
        }
        if (data instanceof DataDrivenDebuffType && (type = (DataDrivenDebuffType)data) == linked) {
            return (D)((IStagedDebuff)this.createRaw());
        }
        return null;
    }

    @Override
    public int getFlags() {
        return IDebuffType.TriggerFlags.HEAL.getValue();
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    public DataDrivenDebuffType<?> getLinkedType() {
        return this.linkedDebuff.get();
    }

    public static final class DummyBuilder<D extends IStagedDebuff>
    implements IDebuffBuilder<D> {
        private Supplier<DataDrivenDebuffType<?>> linkedDebuff;
        private DebuffType.IFactory<D> factory;

        public DummyBuilder<D> factory(DebuffType.IFactory<D> factory) {
            this.factory = factory;
            return this;
        }

        public DummyBuilder<D> linkedTo(Supplier<DataDrivenDebuffType<?>> typeSupplier) {
            this.linkedDebuff = typeSupplier;
            return this;
        }

        public DummyDebuffType<D> build() {
            Objects.requireNonNull(this.factory);
            Objects.requireNonNull(this.linkedDebuff);
            return new DummyDebuffType(this);
        }

        @Override
        public DebuffType.IFactory<D> getFactory() {
            return this.factory;
        }

        @Override
        public BooleanSupplier disabledStatusSupplier() {
            return () -> false;
        }
    }
}

